function disprange = DispRange(handles)
% Allows to add up several energy slices of the DataCube

%% Get Handles
EnergyRes = get(handles.Slider, 'SliderStep');
disprange = str2double(get(handles.DispRange,'String'));

%% Calculate
if disprange<EnergyRes(1)
    disprange=EnergyRes(1);
end
disprange=round(disprange/EnergyRes(1));
if mod(disprange,2)==1
    disprange=disprange*EnergyRes(1);
else
    disprange=(disprange+1)*EnergyRes(1);
end

clearvars -except disprange
end